<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Product extends Model 
{

    protected $table = 'products';
    public $timestamps = true;
    protected $fillable = array('name_ar', 'name_en', 'image', 'price', 'discount', 'is_active', 'colour', 'size', 'description_ar', 'description_en', 'quantity', 'offer_duration', 'state', 'available_quantity', 'store_id');

    public function cart()
    {
        return $this->belongsTo('App\Models\Cart');
    }

    public function orders()
    {
        return $this->belongsToMany('App\Models\Order');
    }

    public function store()
    {
        return $this->belongsTo('App\Models\Store');
    }

    public function clients()
    {
        return $this->belongsToMany('App\Models\Client');
    }

}